/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;
import wayoftime.bloodmagic.common.tile.TileTeleposer;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.event.ItemBindEvent;
import wayoftime.bloodmagic.util.helper.BindableHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ItemSigilTeleposition
extends ItemSigilBase {
    public ItemSigilTeleposition() {
        super("teleposition", 1000);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.m_41720_()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (world.f_46443_ || this.isUnusable(stack)) {
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        Level storedWorld = this.getStoredWorld(stack, world);
        if (storedWorld != null && storedWorld instanceof ServerLevel) {
            ResourceKey<Level> key = this.getStoredKey(stack, world);
            BlockPos telePos = this.getStoredPos(stack);
            BlockEntity tile = storedWorld.m_7702_(telePos);
            if (tile instanceof TileTeleposer) {
                ((TileTeleposer)tile).teleportPlayerToLocation((ServerLevel)storedWorld, player, key, (double)telePos.m_123341_() + 0.5, telePos.m_123342_() + 1, (double)telePos.m_123343_() + 0.5);
                if (!player.m_7500_()) {
                    this.setUnusable(stack, !NetworkHelper.getSoulNetwork(this.getBinding(stack)).syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, this.getLpUsed())).isSuccess());
                }
                storedWorld.m_6263_(null, (double)telePos.m_123341_(), (double)telePos.m_123342_(), (double)telePos.m_123343_(), SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        if (world.m_7702_(pos) instanceof TileTeleposer) {
            ItemBindEvent toPost;
            this.setStoredPos(stack, pos);
            this.setWorld(stack, world);
            Binding binding = this.getBinding(stack);
            if (binding == null && this.onBind(player, stack) && !MinecraftForge.EVENT_BUS.post((Event)(toPost = new ItemBindEvent(player, stack)))) {
                BindableHelper.applyBinding(stack, player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void setStoredPos(ItemStack stack, BlockPos pos) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        tag.m_128405_("xCoord", pos.m_123341_());
        tag.m_128405_("yCoord", pos.m_123342_());
        tag.m_128405_("zCoord", pos.m_123343_());
    }

    public BlockPos getStoredPos(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        return new BlockPos(tag.m_128451_("xCoord"), tag.m_128451_("yCoord"), tag.m_128451_("zCoord"));
    }

    public void setWorld(ItemStack stack, Level world) {
        String worldKey = world.m_46472_().m_135782_().toString();
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128359_("world", worldKey);
    }

    public ResourceKey<Level> getStoredKey(ItemStack stack, Level world) {
        if (!stack.m_41782_()) {
            return null;
        }
        String worldKey = stack.m_41783_().m_128461_("world");
        ResourceKey registryKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(worldKey));
        return registryKey;
    }

    public Level getStoredWorld(ItemStack stack, Level world) {
        ResourceKey<Level> registryKey = this.getStoredKey(stack, world);
        if (registryKey == null || world.m_142572_() == null) {
            return null;
        }
        return world.m_142572_().m_129880_(registryKey);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ResourceKey<Level> storedKey = this.getStoredKey(stack, world);
        if (storedKey != null) {
            BlockPos storedPos = this.getStoredPos(stack);
            tooltip.add((Component)new TranslatableComponent(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionfocus.coords", storedPos.m_123341_(), storedPos.m_123342_(), storedPos.m_123343_())).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.telepositionfocus.world", new Object[]{new TranslatableComponent(storedKey.m_135782_().toString())}).m_130940_(ChatFormatting.GRAY));
        }
    }
}

